/* ============ */
/* runsdefs.h	*/
/* ============ */
/* ==================================================================== */
/*	    TYPEDEFS AND DEFINED MACROS FOR RUNS FUNCTIONS		*/
/* ==================================================================== */
# if defined(__RUNSDEFS_H__)
#		/* Do Nothing. */
# else
# if !defined(__DEFCODES)

typedef	unsigned char		UCHAR;
typedef	unsigned int		UINT;

#define	FALSE	0
#define	TRUE	1
# endif

#define	MAX_CELL_XPCT	15		/* Max. Expectation/Category	*/
#define	MIN_CELL_XPCT	5		/* Min. Expectation/Category	*/
#define	MAX_RUN_CATS	6		/* Max. No. Run Categories	*/
#define	DEG_FREE	MAX_RUN_CATS-1	/* Deg. Free in chi-Square	*/
#define	NUM_PROBS	100		/* No. ChiSquare Probabilities	*/

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */

typedef	struct	RunDataStru
    {
	UINT	NumRand;                /* Number of Variates Desired	*/
	long	MaxGenCount;		/* Maximum Generator Count	*/
	UINT	ActRandCount;		/* Actual No. Variates Stored	*/
	long	ActGenCount;		/* Actual Generator Count	*/
	long	TotVariates;		/* Total # Variates - All Runs	*/
	long	RunCtrs[7];		/* Run Counters			*/
	int	CallStatus;		/* 0 = Failure, 1 = Success	*/
	int	(*RandFun) F((void));	/* Address of Generating Fcn.	*/
	double	*ChiSqProb;
	int	*RandArray;		/* Address of Receiving Area	*/
    }
    RUN_DATA_STRU;

extern	void	CountRuns F((RUN_DATA_STRU *));
extern	void	GenerateChiSquareData F((RUN_DATA_STRU *));
extern	void	GenRunData F((RUN_DATA_STRU *));
extern	void	RunMeanStdDev F((UINT, UINT, double *, double *));
extern	void	SetRunControls F((RUN_DATA_STRU *));

# undef F
/* INDENT ON */
# endif		/* << __RUNSDEFS_H__ >>	*/
